package kom.itbeankit.common.vcr;

/**
This Bean contains a VCR-panel with various Buttons to control other Beans
by firing ItBeanFrameEvents. It includes the Symantec-Timer-Component.
Pressing a button starts the Timer with or without repeat depending on which
button was pressed.
Designed with Visual Caf.
@author Alexander Kempf
@version 0.0 1998/06/30

@version 0.1 27.07.1998, A. El saddik, Alexander Kempf
add BackwardsButton
add userComplexityLevel
@version 0.2 27.07.1998, A. El saddik, Ramon Faja
add numberOfComplexityLevel

*/

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;


public class ControlButtonPanel extends java.awt.Container
{
    protected boolean risingClkEdge = false;
    public void fireClkEvent(boolean risingEdge)
    {
            for(int i=0; i<clkListeners.size();i++){
                ClkListener cl = (ClkListener)clkListeners.elementAt(i);
                cl.clkReceived(new ClkEvent(this,risingEdge));
            }
    }
    public synchronized void removeClkListener (ClkListener l)
    {
        clkListeners.removeElement(l);
    }
    public synchronized void addClkListener (ClkListener l)
    {
        clkListeners.addElement(l);
    }
    protected Vector clkListeners = new Vector();


    /**
    This constructor creates an ControlButtonPanel-object with 4 buttons:
    playButton, stepButton, stopButton, hideButton
    Also a timer is instantiated.
    Most of the constructor was generated by Visual Caf
    */
    SymAction lSymAction = new SymAction();

	public ControlButtonPanel()
	{
		//{{INIT_CONTROLS
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		setLayout(gridBagLayout);
		//setSize(100,43);
		stopButton = new java.awt.Button();
		stopButton.setActionCommand("stop");
		stopButton.setLabel("stop");
		//stopButton.setBounds(66,0,60,43);
		stopButton.setBackground(new Color(12632256));
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 22;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(stopButton, gbc);
		add(stopButton);
		// Backwards
		backwardsButton = new java.awt.Button();
		backwardsButton.setActionCommand("backwards");
		backwardsButton.setLabel("<< step");
		//stepButton.setBounds(126,0,60,43);
		backwardsButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 22;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(backwardsButton, gbc);
		add(backwardsButton);

		// End Backwards
		stepButton = new java.awt.Button();
		stepButton.setActionCommand("forwards");
		stepButton.setLabel("step >>");
		//stepButton.setBounds(126,0,60,43);
		stepButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 3;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 22;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(stepButton, gbc);
		add(stepButton);
		playButton = new java.awt.Button();
		playButton.setActionCommand("play");
		playButton.setLabel("play");
		//playButton.setBounds(186,0,60,43);
		playButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 4;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 24;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(playButton, gbc);
		add(playButton);
		hideButton = new java.awt.Button();
		hideButton.setActionCommand("hide");
		hideButton.setLabel("hide");
		//hideButton.setBounds(246,0,49,43);
		hideButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 5;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 11;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(hideButton, gbc);
		add(hideButton);

		/// Begin: Buttons for the user complexity level
		blankLabel = new java.awt.Label();
		blankLabel.setBackground(new Color(255,255,255));
		gbc = new GridBagConstraints();
		gbc.gridx = 6;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 11;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(blankLabel, gbc);
		add(blankLabel);

		userComplexityLevelLabel = new java.awt.Label("Level: " + theComplexityLevel, Label.CENTER);
		//userComplexityLevelLabel.setText("Level: " + theComplexityLevel, Label.CENTER);
		//hideButton.setBounds(246,0,49,43);
		userComplexityLevelLabel.setBackground(new Color(255,255,255));
		gbc = new GridBagConstraints();
		gbc.gridx = 7;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 11;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(userComplexityLevelLabel, gbc);
		add(userComplexityLevelLabel);

		levelDownButton = new java.awt.Button();
		levelDownButton.setActionCommand("levelDown");
		levelDownButton.setLabel("<<");
		//hideButton.setBounds(246,0,49,43);
		//levelDownButton.setEnabled(false);
		levelDownButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 8;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 11;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(levelDownButton, gbc);
		add(levelDownButton);

		levelUpButton = new java.awt.Button();
		levelUpButton.setActionCommand("levelUp");
		levelUpButton.setLabel(">>");
		//hideButton.setBounds(246,0,49,43);
		levelUpButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 9;
		gbc.gridy = 0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.VERTICAL;
		gbc.insets = new Insets(0,0,0,0);
		gbc.ipadx = 11;
		gbc.ipady = 17;
		((GridBagLayout)getLayout()).setConstraints(levelUpButton, gbc);
		add(levelUpButton);
		/// End: Buttons for the user complexity level
        timer1 = new VCRClock(1000);
      // timer
		//}}

		//{{REGISTER_LISTENERS
		SymAction lSymAction = new SymAction();
		playButton.addActionListener(lSymAction);
		stopButton.addActionListener(lSymAction);
		stepButton.addActionListener(lSymAction);
		backwardsButton.addActionListener(lSymAction);
		hideButton.addActionListener(lSymAction);

		levelDownButton.addActionListener(lSymAction);
		levelUpButton.addActionListener(lSymAction);
		timer1.addActionListener(lSymAction);
		//}}
	}
	//{{DECLARE_CONTROLS
	java.awt.Button stopButton;
	java.awt.Button stepButton;
	java.awt.Button backwardsButton;
	java.awt.Button playButton;
	java.awt.Button hideButton;

	java.awt.Button  levelDownButton;
   java.awt.Button  levelUpButton;
   java.awt.Label   userComplexityLevelLabel;
   java.awt.Label   blankLabel;
   VCRClock timer1;
    private int theComplexityLevel=1;
    private int numberOfComplexityLevels=10;
	//}}
	private Vector actionListeners = new Vector();
	private boolean play = false;
    private int timerDelay = 1000;

    public final static int STOP_BUTTON = 7000;
    public final static int BACKWARD_BUTTON = 7001;
    public final static int FORWARD_BUTTON = 7002;
    public final static int PLAY_BUTTON = 7003;
    public final static int HIDE_BUTTON = 7004;


/**
This class was generated by Visual Caf.
It's an inner class that plays the role of an ActionEventAdapter.
Any ActionEvent caused by VCR-buttons or the timer will invoke a
corresponding method.
*/

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == playButton)
				playButton_ActionPerformed(event);
			else if (object == stopButton)
				stopButton_ActionPerformed(event);
			else if (object == stepButton)
				stepButton_ActionPerformed(event);
				else if (object == backwardsButton)
				backwardsButton_ActionPerformed(event);
			else if (object == hideButton)
				hideButton_ActionPerformed(event);
			else if (object == levelDownButton)
				levelDownButton_ActionPerformed(event);
			else if (object == levelUpButton)
				levelUpButton_ActionPerformed(event);
			else if (object == timer1)
				timer1_ActionPerformed(event);

		}
	}

    /**
    This method is invoked if the playButton sources an ActionEvent.
    It sets the timer to repeat and invokes the timer's resume()-method.
    It sets the ActionCommand to "play".
    */

	void playButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.


		if(play) {
         playButton.setLabel("play");
         playButton.setActionCommand("pause");
         //{{CONNECTION
         // Stop Clock
         timer1.stop();
         //}}
         fireActionEvent(playButton.getActionCommand());
		}
		else {
         playButton.setLabel("pause");
         playButton.setActionCommand("play");
         timer1.setActionCommand(playButton.getActionCommand());
			fireActionEvent(playButton.getActionCommand());
         //{{CONNECTION
         // Start Clock
         //   System.out.println("Clock lebt nicht! Anzahl Threads: " + timer1.activeCount());
            timer1.stop();
    		timer1.removeActionListener(lSymAction);
            timer1 = new VCRClock(timerDelay); // Abed & Dirk 18.12.98
            timer1.setActionCommand(playButton.getActionCommand());
    		timer1.addActionListener(lSymAction);
            timer1.start();
        } /* endif */
    	play = !play;
	}

    /**
    This method is invoked if the stopButton sources an ActionEvent.
    It invokes the timer's stop()-method.
    It sets the ActionCommand to "stop".
    */

	void stopButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
		if(play) playButton.setLabel("play");
		play = false;
		//{{CONNECTION
      // Stop Clock
	    timer1.stop();

		//}}
		fireActionEvent(stopButton.getActionCommand());
	}




    /**
    This method is invoked if the stepButton sources an ActionEvent.
    It sets the timer to not repeat and invokes the timer's start()-method.
    It sets the ActionCommand to "forwards".
    */
	void stepButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
        // to do: code goes here.
	    timer1.setActionCommand(stepButton.getActionCommand());

		if(play) playButton.setLabel("play");
		play = false;

		timer1.stop();

        timer1 = new VCRClock(timerDelay); // Abed & Dirk 18.12.98
        fireActionEvent(stepButton.getActionCommand());
        timer1.addActionListener(lSymAction);
        timer1.start();
       try{
        Thread.sleep(200);
       }catch (Exception e) {}
    	timer1.stop();
      //  fireActionEvent(stepButton.getActionCommand());

	}

    //////////
    /**
    This method is invoked if the backwardsButton sources an ActionEvent.
    It sets the timer to not repeat and invokes the timer's start()-method.
    It sets the ActionCommand to "forwards".
    */
	void backwardsButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.

		if(play) playButton.setLabel("play");
		play = false;
		//{{CONNECTION
      // Stop Clock
		timer1.stop();
		//}}
		fireActionEvent(backwardsButton.getActionCommand());
	}


   /**
   This method is invoked if the hideButton sources an ActionEvent.
   It invokes the timer's pause()-method.
   It sets the ActionCommand to "hide".
   */
	void hideButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
		fireActionEvent(hideButton.getActionCommand());

	}


   /**
   This method is invoked if the timer sources an ActionEvent.
   It just invokes the fireActionEvent()-method.
   */
	void timer1_ActionPerformed(java.awt.event.ActionEvent event)
   {
       fireActionEvent(timer1.getActionCommand());
        fireClkEvent(true);
        fireClkEvent(false);


	}


    public void setNumberOfComplexityLevels(int nc) {
      numberOfComplexityLevels = nc;
      if ( numberOfComplexityLevels == 1){
        levelDownButton.setEnabled(false);
        levelUpButton.setEnabled(false);
      }
    }

     public int getNumberOfComplexityLevels() {
      return numberOfComplexityLevels;
    }



    /**
    This method is invoked if the levelDownButton sources an ActionEvent.
    It sets the ActionCommand to "levelDown".
    */
    void levelDownButton_ActionPerformed(java.awt.event.ActionEvent event)
    {
         changeLevelDown();
	}


// Damit wahrscheinlich die theComplexityLevel automatisch geaendert wird
     void changeLevelDown() {

     if (theComplexityLevel == 2) {
        levelDownButton.setEnabled(false);
        levelUpButton.setEnabled(true);
        theComplexityLevel--;
      }
      else if ((theComplexityLevel <= (numberOfComplexityLevels)) & (theComplexityLevel>2)){
        levelUpButton.setEnabled(true);
        theComplexityLevel--;
      }
      else if (theComplexityLevel == 1) {
        levelDownButton.setEnabled(false);
      }
	  fireActionEvent(levelDownButton.getActionCommand());
	  //theComplexityLevel--;
	  userComplexityLevelLabel.setText("Level: " + theComplexityLevel);
	  userComplexityLevelLabel.setAlignment(Label.CENTER);

     }



    /**
    This method is invoked if the levelDownButton sources an ActionEvent.
    It sets the ActionCommand to "levelDown".
    */
    void levelUpButton_ActionPerformed(java.awt.event.ActionEvent event)
    {
       changeLevelUp();
	}

// Damit wahrscheinlich die theComplexityLevel automatisch geaendert wird
     void changeLevelUp() {


       if (theComplexityLevel == (numberOfComplexityLevels - 1)) {
        levelUpButton.setEnabled(false);
        levelDownButton.setEnabled(true);
        theComplexityLevel++;
      }
      else if ((theComplexityLevel >= 1) & (theComplexityLevel < numberOfComplexityLevels )){
        levelDownButton.setEnabled(true);
        theComplexityLevel++;
      }
      else if (theComplexityLevel == numberOfComplexityLevels) {
        levelUpButton.setEnabled(false);
      }
      fireActionEvent(levelUpButton.getActionCommand());
	  //theComplexityLevel++;
	  userComplexityLevelLabel.setText("Level: " + theComplexityLevel);

    }


	/**
	This method adds an ActionListener to the list.
	*/

    public synchronized void addActionListener (ActionListener l) {
        actionListeners.addElement(l);
    }

    /**
    This method removes an ActionListener from the list.
    */

    public synchronized void removeActionListener (ActionListener l) {
        actionListeners.removeElement(l);
    }

    /**
    This method calls the actionPerformed()-method of all Listeners.
    It uses an ActionEvent as an argument.
    */

	public void fireActionEvent(ActionEvent evt) {
	    String actionCommand = evt.getActionCommand();
	    for(int i=0; i < actionListeners.size(); i++) {
	        ActionListener il = (ActionListener)actionListeners.elementAt(i);
	        il.actionPerformed(new ActionEvent(this,ActionEvent.ACTION_PERFORMED,actionCommand));
	    }

	}

	/**
    This method calls the actionPerformed()-method of all Listeners.
    It uses a String as an argument.
    */

	public void fireActionEvent(String actionCommand) {
	    for(int i=0; i < actionListeners.size(); i++) {
	        ActionListener il = (ActionListener)actionListeners.elementAt(i);
	        il.actionPerformed(new ActionEvent(this,ActionEvent.ACTION_PERFORMED,actionCommand));
	    }

	}

   public void setComplexityLevel(int level) {
        if (level < theComplexityLevel) {
             theComplexityLevel = level;
             changeLevelDown();
        }
        else if (level > theComplexityLevel) {
             theComplexityLevel = level;
             changeLevelUp();
        }
	}


    public int getComplexityLevel() {
	    return theComplexityLevel;
	}


   /**
	This method gives back the timerDelay.
	*/
	public int getTimerDelay() {
	    return timerDelay;
	}


	/**
	This method sets the timerDelay.
	*/
	public void setTimerDelay(int delayTime)
   {
      timerDelay = delayTime;
      timer1.setDelayTime(timerDelay);
   }


    /**
	This method enables/disables the buttons and the
	timer except the hide and level control buttons.
	@param flag true to enable the buttons and the timer
	*/
	public void setEnabled(boolean flag) {
	    if (!flag) this.timer1.suspend();
	    this.stopButton.setEnabled(flag);
	    this.stepButton.setEnabled(flag);
	    this.backwardsButton.setEnabled(flag);
	    this.playButton.setEnabled(flag);
	}


	/**
	This method enables/disables the buttons one wishes and the
	timer except the hide and level control buttons.

	@param int button number as follow:
	STOP_BUTTON, BACKWARD_BUTTON, FORWARD_BUTTON, PLAY_BUTTON, HIDE_BUTTON
	@param flag true to enable the buttons and the timer

	*/
	public void setEnabled(int buttonNr, boolean flag) {
	    switch (buttonNr) {
	        case STOP_BUTTON:
	            this.stopButton.setEnabled(flag);
	            break;
	        case BACKWARD_BUTTON:
	            this.backwardsButton.setEnabled(flag);
	            break;
	        case FORWARD_BUTTON:
	            this.stepButton.setEnabled(flag);
	            break;
	        case PLAY_BUTTON:
	            this.playButton.setEnabled(flag);
	            break;
	        case HIDE_BUTTON:
	            this.hideButton.setEnabled(flag);
	            break;
	        default:
	    }
	}


   /**
   This method kills the thread of the timer
   */
   public void TimerStop()
   {
      timer1.stop();
   }

}